/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.mixin.client;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.mainwindow.MainWindowHandler;
import de.keksuccino.fancymenu.menu.animation.AdvancedAnimation;
import de.keksuccino.fancymenu.menu.animation.AnimationHandler;
import de.keksuccino.fancymenu.menu.animation.ResourcePackAnimationRenderer;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.mixin.cache.MixinCache;
import de.keksuccino.konkrete.rendering.animation.IAnimationRenderer;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.LoadingGui;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Minecraft.class})
public class MixinMinecraft {
    private static boolean customWindowInit = false;
    private static boolean animationsLoaded = false;

    @Inject(at={@At(value="HEAD")}, method={"getWindowTitle"}, cancellable=true)
    private void onGetWindowTitle(CallbackInfoReturnable<String> info) {
        String title;
        if (FancyMenu.config != null && !customWindowInit) {
            MainWindowHandler.init();
            MainWindowHandler.updateWindowIcon();
            MainWindowHandler.updateWindowTitle();
            customWindowInit = true;
        }
        if ((title = MainWindowHandler.getCustomWindowTitle()) != null) {
            info.setReturnValue((Object)title);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"setLoadingGui"}, cancellable=false)
    private void onSetLoadingGui(LoadingGui loadingGuiIn, CallbackInfo info) {
        if (FancyMenu.config == null) {
            return;
        }
        if (loadingGuiIn == null) {
            MixinMinecraft.preloadAnimations();
            MixinCache.isSplashScreenRendering = false;
            MenuCustomization.isLoadingScreen = false;
            MenuCustomization.reloadCurrentMenu();
        } else {
            MenuCustomization.isLoadingScreen = true;
        }
    }

    private static void preloadAnimations() {
        if (((Boolean)FancyMenu.config.getOrDefault("preloadanimations", (Object)true)).booleanValue()) {
            if (!animationsLoaded) {
                System.out.println("[FANCYMENU] LOADING ANIMATION TEXTURES! THIS CAUSES THE LOADING SCREEN TO FREEZE FOR A WHILE!");
                try {
                    ArrayList<ResourcePackAnimationRenderer> l = new ArrayList<ResourcePackAnimationRenderer>();
                    for (IAnimationRenderer iAnimationRenderer : AnimationHandler.getAnimations()) {
                        if (iAnimationRenderer instanceof AdvancedAnimation) {
                            IAnimationRenderer main = ((AdvancedAnimation)iAnimationRenderer).getMainAnimationRenderer();
                            IAnimationRenderer intro = ((AdvancedAnimation)iAnimationRenderer).getIntroAnimationRenderer();
                            if (main != null && main instanceof ResourcePackAnimationRenderer) {
                                l.add((ResourcePackAnimationRenderer)main);
                            }
                            if (intro == null || !(intro instanceof ResourcePackAnimationRenderer)) continue;
                            l.add((ResourcePackAnimationRenderer)intro);
                            continue;
                        }
                        if (!(iAnimationRenderer instanceof ResourcePackAnimationRenderer)) continue;
                        l.add((ResourcePackAnimationRenderer)iAnimationRenderer);
                    }
                    for (ResourcePackAnimationRenderer resourcePackAnimationRenderer : l) {
                        for (ResourceLocation rl : resourcePackAnimationRenderer.getAnimationFrames()) {
                            TextureManager t = Minecraft.func_71410_x().func_110434_K();
                            Texture to = t.func_229267_b_(rl);
                            if (to != null) continue;
                            to = new SimpleTexture(rl);
                            t.func_229263_a_(rl, to);
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                System.out.println("[FANCYMENU] FINISHED LOADING ANIMATION TEXTURES!");
                animationsLoaded = true;
            }
        } else {
            animationsLoaded = true;
        }
    }
}

